//
//  CMSFeedDetailViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 13/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
let STORYBOARD_ID_CMSFeedDetailViewController = "CMSFeedDetailViewController"
class CMSFeedDetailViewController: UIViewController {
    @IBOutlet weak var webViewFeedDescription: UIWebView!
    weak var feedItem: RSSItem?
    @IBOutlet weak var lblSubmittedBy: UILabel!
    @IBOutlet weak var imageView: UIImageView!


    convenience override init() {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSFeedDetailViewController)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.navigationItem.title! = feedItem!.title
        webViewFeedDescription.loadHTMLString(feedItem!.itemDescription, baseURL: nil)
        lblSubmittedBy.text = "Submitted by: \(CMS_Strings.trim(feedItem!.author)), \(CMS_Strings.trim(feedItem!.category)), \(feedItem!.pubDate)"
        print("\(lblSubmittedBy.text)")
        if feedItem!.enclosureUrl != nil && !(CMS_Strings.trim(feedItem!.enclosureUrl) == "") {
            self.imageView!.setImageWithURL(NSURL(string: feedItem!.enclosureUrl)!, placeholderImage: UIImage(named: nil)!)
        }
        else {
            self.imageView!.hidden = true
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
// MARK: webviewdelegate

    func webView(webView: UIWebView, shouldStartLoadWithRequest request: NSURLRequest, navigationType: UIWebViewNavigationType) -> Bool {
        return true
    }
}
//
//  CMSFeedDetailViewController.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 13/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//